# Ansible Playbook for Sinopia

An ansible playbook to build sinopia server

**Important**: This script will update your nodejs to a stable version
#### defined variables ####

AWS_DEV:
    
    sinopia_user: sinopia
    sinopia_base_dir: "/var/www/html/pub/npm/sinopia"
    sinopia_host: "http://34.195.104.160"
    sinopia_port: 4873

### How to run the installation

#### In another machine

Install ansible in your machine and clone this repository.
Edit the inventory file with the host's ips you want to run sinopia on
Run:

```bash
ansible-playbook -i inventory playbook.yml -u <machine-user> -kK
```

### How to publish packages

Run this in your machine:

```bash
$npm set registry http://{{ sinopia_host }}:{{ sinopia_port }}
```

Create a user (in this case any user is allowed):

```bash
$npm adduser --registry http://{{ sinopia_host }}:{{ sinopia_port }}
```

This settings will be saved in your ~/.npmrc now it's only a matter to run:

```bash
$npm publish
```

### Packages installed by Ansible
* mccfrolenodejs

### Configurations made by Ansible

* Sinopia web base, sinopia_base_dir: /var/www/html/pub/repo/npm/sinopia
* URL: http://{{ sinopia_host }}:{{ sinopia_port }}/
* Create user called sinopia in the server
* Install sinopia with a non-restriction config file which means that everyone will be able to pubilsh and read packages


### What if I want to restrict access to sinopia?

* Change config file
* Go to the server and run $npm login or $npm adduser. It will create a user and sinopia will use it
* After that don't forget to ask you team to run: $npm adduser --registry http://{{ sinopia_host }}:{{ sinopia_port }}
=======
#README
